/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.evolvedmekanism.blocks;

import fr.iglee42.evolvedmekanism.inventory.personalstorage.TieredPersonalStorageManager;
import fr.iglee42.evolvedmekanism.loot.PersonalTieredStorageContentsLootFunction;
import fr.iglee42.evolvedmekanism.tiers.PersonalStorageTier;
import fr.iglee42.evolvedmekanism.tiles.TileEntityTieredPersonalStorage;
import java.util.List;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.block.BlockPersonalStorage;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.Attributes;
import mekanism.common.content.blocktype.BlockTypeTile;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockTieredPersonalStorage<TILE extends TileEntityTieredPersonalStorage, BLOCK extends BlockTypeTile<TILE>>
extends BlockPersonalStorage<TILE, BLOCK> {
    public static final Attribute TIERED_PERSONAL_STORAGE_INVENTORY = new Attributes.AttributeInventory((lootBuilder, nbtBuilder) -> {
        lootBuilder.m_79078_(PersonalTieredStorageContentsLootFunction.builder());
        return true;
    });
    private final PersonalStorageTier tier;

    public BlockTieredPersonalStorage(BLOCK type, PersonalStorageTier tier) {
        super(type, properties -> properties.m_284180_(MapColor.f_283818_));
        this.tier = tier;
    }

    public void m_6402_(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity placer, @NotNull ItemStack stack) {
        super.m_6402_(world, pos, state, placer, stack);
        if (!world.f_46443_) {
            TieredPersonalStorageManager.getInventoryIfPresent(stack).ifPresent(storageItemInventory -> {
                block5: {
                    block6: {
                        TileEntityTieredPersonalStorage tile = (TileEntityTieredPersonalStorage)WorldUtils.getTileEntity(TileEntityTieredPersonalStorage.class, (BlockGetter)world, (BlockPos)pos);
                        if (tile == null) {
                            return;
                        }
                        List<IInventorySlot> inventorySlots = storageItemInventory.getInventorySlots(null);
                        for (int i = 0; i < inventorySlots.size(); ++i) {
                            IInventorySlot itemSlot = inventorySlots.get(i);
                            tile.setStackInSlot(i, itemSlot.getStack().m_41777_());
                        }
                        if (stack.m_41613_() != 1) break block5;
                        if (!(placer instanceof Player)) break block6;
                        Player player = (Player)placer;
                        if (player.m_150110_().f_35937_) break block5;
                    }
                    TieredPersonalStorageManager.deleteInventory(stack);
                }
            });
        }
    }

    public PersonalStorageTier getTier() {
        return this.tier;
    }
}

